from django.shortcuts import render, redirect, get_object_or_404
from django.views import View
from django.contrib.auth.mixins import LoginRequiredMixin
from banners.models import Banner
from django.contrib import messages

class BannerManagementView(LoginRequiredMixin, View):
    def get(self, request):
        banners = Banner.objects.all()
        return render(request, 'pages/banner-management/banner_management.html', {'banners': banners})

class BannerCreateView(LoginRequiredMixin, View):
    def get(self, request):
        return render(request, 'pages/banner-management/banner_create.html')

    def post(self, request):
        Banner.objects.create(
            title=request.POST.get('title'),
            description=request.POST.get('description'),
            image=request.FILES.get('image'),
            status=request.POST.get('status'),
        )
        messages.success(request, 'Banner created successfully!')
        return redirect('banner-management')

class BannerDetailViewWeb(LoginRequiredMixin, View):
    def get(self, request, pk):
        banner = get_object_or_404(Banner, pk=pk)
        return render(request, 'pages/banner-management/banner_detail.html', {'banner': banner})

class BannerEditView(LoginRequiredMixin, View):
    def get(self, request, pk):
        banner = get_object_or_404(Banner, pk=pk)
        return render(request, 'pages/banner-management/banner_edit.html', {'banner': banner})

    def post(self, request, pk):
        banner = get_object_or_404(Banner, pk=pk)
        banner.title = request.POST.get('title')
        banner.description = request.POST.get('description')
        if request.FILES.get('image'):
            banner.image = request.FILES.get('image')
        banner.status = request.POST.get('status')
        banner.save()
        messages.success(request, 'Banner updated successfully!')
        return redirect('banner-management')

class BannerDeleteView(LoginRequiredMixin, View):
    def post(self, request, pk):
        banner = get_object_or_404(Banner, pk=pk)
        banner.delete()
        messages.success(request, 'Banner deleted successfully!')
        return redirect('banner-management')
