from django.db import models
from category.models import Category

class Garment(models.Model):
    STATUS_CHOICES = [
        ('active', 'Active'),
        ('inactive', 'Inactive'),
    ]
    GARMENT_TYPE_CHOICES = [
        ('normal', 'Normal'),
        ('premium', 'Premium'),
        ('luxury', 'Luxury'),
    ]
    name = models.CharField(max_length=255)
    category = models.ForeignKey(Category, null=True, blank=True, on_delete=models.SET_NULL, related_name='garments')
    status = models.CharField(max_length=10, choices=STATUS_CHOICES, default='active')
    garment_type = models.CharField(max_length=20, choices=GARMENT_TYPE_CHOICES, default='normal')
    description = models.TextField(blank=True)
    trash = models.BooleanField(default=False)

    service_prices = models.JSONField(default=list, blank=True, help_text='List of objects: {"service_id": int, "price": float}')
    created_at = models.DateTimeField(auto_now_add=True)
    deleted_at = models.DateTimeField(null=True, blank=True)

    def __str__(self):
        return self.name
