from django.apps import AppConfig


class RidersConfig(AppConfig):
    default_auto_field = 'django.db.models.BigAutoField'
    name = 'riders'

    def ready(self):
        # Import signal handlers to wire user <-> rider synchronization
        try:
            import riders.signals  # noqa: F401
        except Exception:
            # Avoid failing app import if signals fail during migrations
            pass
