from django.urls import path
from .views import (
    BannerManagementView, BannerCreateView, BannerDetailViewWeb, BannerEditView, BannerDeleteView
)

urlpatterns = [
    path('banner-management/', BannerManagementView.as_view(), name='banner-management'),
    path('banner-management/create', BannerCreateView.as_view(), name='banner-create'),
    path('banner-management/<int:pk>/', BannerDetailViewWeb.as_view(), name='banner-view'),
    path('banner-management/<int:pk>/edit/', BannerEditView.as_view(), name='banner-edit'),
    path('banner-management/<int:pk>/delete/', BannerDeleteView.as_view(), name='banner-delete'),
]
