
from django.db import models

class Category(models.Model):
	STATUS_CHOICES = [
		('active', 'Active'),
		('inactive', 'Inactive'),
	]
	id = models.AutoField(primary_key=True)
	name = models.CharField(max_length=255, blank=True)
	parent = models.ForeignKey('self', null=True, blank=True, on_delete=models.SET_NULL, related_name='children')
	image = models.ImageField(upload_to='category/', null=True, blank=True)
	description = models.TextField(blank=True)
	status = models.CharField(max_length=10, choices=STATUS_CHOICES, default='active')
	trash = models.BooleanField(default=False)
	created_at = models.DateTimeField(auto_now_add=True)
	deleted_at = models.DateTimeField(null=True, blank=True)

	def __str__(self):
		if self.name:
			return self.name
		return f"{self.description[:30]}" if self.description else f"Category {self.id}"
