from django.urls import path
from .views import (
    GarmentManagementView, GarmentCreateView, GarmentDetailViewWeb, GarmentEditView, GarmentDeleteView
)

urlpatterns = [
    path('garment-management/', GarmentManagementView.as_view(), name='garment-management'),
    path('garment-management/create', GarmentCreateView.as_view(), name='garment-create'),
    path('garment-management/<int:pk>/', GarmentDetailViewWeb.as_view(), name='garment-view'),
    path('garment-management/<int:pk>/edit/', GarmentEditView.as_view(), name='garment-edit'),
    path('garment-management/<int:pk>/delete/', GarmentDeleteView.as_view(), name='garment-delete'),
]
