from django.db import models


class GlobalSetting(models.Model):
    cgst = models.DecimalField(max_digits=5, decimal_places=2, default=0)
    sgst = models.DecimalField(max_digits=5, decimal_places=2, default=0)
    platform_charges = models.DecimalField(max_digits=7, decimal_places=2, default=0)
    additional_charges = models.DecimalField(max_digits=9, decimal_places=2, default=0)
    time_slots = models.JSONField(default=list, blank=True, help_text='List of time slot strings e.g. ["09:00 - 11:00"]')
    distance_charges = models.JSONField(default=list, blank=True, help_text='List of distance charge objects e.g. [{"range": "0-5", "charge": 20}]')
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return "Global Settings"

    class Meta:
        verbose_name = 'Global Setting'
        verbose_name_plural = 'Global Settings'
from django.db import models

# Create your models here.
