from rest_framework import generics, permissions
from .models import Material
from .serializers import MaterialSerializer

class MaterialListAPIView(generics.ListAPIView):
    queryset = Material.objects.filter(status='active', trash=False).order_by('-created_at')
    serializer_class = MaterialSerializer
    permission_classes = [permissions.AllowAny]
    pagination_class = None
