from django.db import models
from products.models import Product
from services.models import Service

class Offer(models.Model):
    OFFER_TYPE_CHOICES = [
        ('percentage', 'Percentage'),
        ('fixed_amount', 'Fixed Amount'),
        ('buy_x_get_y', 'Buy X Get Y'),
    ]

    code = models.CharField(max_length=50, unique=True)
    name = models.CharField(max_length=255)
    description = models.TextField(blank=True, null=True)
    slug = models.SlugField(unique=True, blank=True, null=True)
    
    offer_type = models.CharField(max_length=20, choices=OFFER_TYPE_CHOICES, default='percentage')
    
    discount_percentage = models.DecimalField(max_digits=5, decimal_places=2, null=True, blank=True)
    discount_amount = models.DecimalField(max_digits=10, decimal_places=2, null=True, blank=True)
    max_discount_amount = models.DecimalField(max_digits=10, decimal_places=2, null=True, blank=True)
    
    buy_quantity = models.IntegerField(null=True, blank=True)
    get_quantity = models.IntegerField(null=True, blank=True)
    get_discount_percent = models.DecimalField(max_digits=5, decimal_places=2, null=True, blank=True)
    gift_product = models.ForeignKey(Product, on_delete=models.SET_NULL, null=True, blank=True, related_name='gift_offers')
    
    apply_to_all = models.BooleanField(default=False)
    
    minimum_purchase_amount = models.DecimalField(max_digits=10, decimal_places=2, null=True, blank=True)
    maximum_purchase_amount = models.DecimalField(max_digits=10, decimal_places=2, null=True, blank=True)
    minimum_quantity = models.IntegerField(null=True, blank=True)
    
    usage_limit_total = models.IntegerField(null=True, blank=True)
    usage_limit_per_user = models.IntegerField(null=True, blank=True)
    used_count = models.IntegerField(default=0)
    
    is_active = models.BooleanField(default=True)
    auto_apply = models.BooleanField(default=False)
    exclude_sale_items = models.BooleanField(default=False)
    first_order_only = models.BooleanField(default=False)
    priority = models.IntegerField(default=0)
    
    start_date = models.DateTimeField(null=True, blank=True)
    end_date = models.DateTimeField(null=True, blank=True)
    
    brands = models.JSONField(default=list, blank=True, help_text="List of Brand Names")
    categories = models.JSONField(default=list, blank=True, help_text="List of Category Names")
    products = models.JSONField(default=list, blank=True, help_text="List of Product Names")
    services = models.ManyToManyField(Service, blank=True, related_name='offers')
    
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.name
