from django.shortcuts import render, redirect, get_object_or_404
from django.contrib import messages
from .models import Offer
from .forms import OfferForm

def offer_list(request):
    offers = Offer.objects.all().order_by('-created_at')
    return render(request, 'offers/offer_list.html', {'offers': offers})

def offer_create(request):
    if request.method == 'POST':
        form = OfferForm(request.POST)
        if form.is_valid():
            form.save()
            messages.success(request, 'Offer created successfully.')
            return redirect('offer_list')
    else:
        form = OfferForm()
    return render(request, 'offers/offer_form.html', {'form': form, 'title': 'Create Offer'})

def offer_update(request, pk):
    offer = get_object_or_404(Offer, pk=pk)
    if request.method == 'POST':
        form = OfferForm(request.POST, instance=offer)
        if form.is_valid():
            form.save()
            messages.success(request, 'Offer updated successfully.')
            return redirect('offer_list')
    else:
        form = OfferForm(instance=offer)
    return render(request, 'offers/offer_form.html', {'form': form, 'title': 'Update Offer'})

def offer_detail(request, pk):
    offer = get_object_or_404(Offer, pk=pk)
    return render(request, 'offers/offer_detail.html', {'offer': offer})

def offer_delete(request, pk):
    offer = get_object_or_404(Offer, pk=pk)
    if request.method == 'POST':
        offer.delete()
        messages.success(request, 'Offer deleted successfully.')
        return redirect('offer_list')
    return render(request, 'offers/offer_confirm_delete.html', {'offer': offer})
