from django.urls import path
from .views import (
    ProductManagementView, ProductCreateView, ProductDetailViewWeb, ProductEditView, ProductDeleteView
)

urlpatterns = [
    path('product-management/', ProductManagementView.as_view(), name='product-management'),
    path('product-management/create', ProductCreateView.as_view(), name='product-create'),
    path('product-management/<int:pk>/', ProductDetailViewWeb.as_view(), name='product-view'),
    path('product-management/<int:pk>/edit/', ProductEditView.as_view(), name='product-edit'),
    path('product-management/<int:pk>/delete/', ProductDeleteView.as_view(), name='product-delete'),
]
