from django.contrib import admin
from .models import Rider


@admin.register(Rider)
class RiderAdmin(admin.ModelAdmin):
	list_display = ('user', 'full_name', 'display_name', 'mobile_number', 'email', 'status', 'trash')
	search_fields = ('full_name', 'display_name', 'mobile_number', 'email', 'user__username')
	list_filter = ('status', 'trash')

