from django.contrib import admin
from .models import BackToBase

@admin.register(BackToBase)
class BackToBaseAdmin(admin.ModelAdmin):
    list_display = ('id', 'booking', 'rider', 'customer', 'created_at')
    search_fields = ('booking__booking_id', 'rider__full_name', 'customer__email', 'customer__mobile')
    list_filter = ('created_at',)

