from django.urls import path
from .views import BookingManagementView, BookingEditView, BookingDetailView, BookingItemUpdateView, BookingDeleteView, BookingItemDeleteView, TagListView, BookingTagsView, BookingTagPrintView

urlpatterns = [
    path('booking-management/', BookingManagementView.as_view(), name='booking-management'),
    path('tag-management/', TagListView.as_view(), name='tag-management'),
    path('booking-management/<int:pk>/', BookingDetailView.as_view(), name='booking-view'),
    path('booking-management/<int:pk>/tags/', BookingTagsView.as_view(), name='booking-tags'),
    path('booking-management/<int:pk>/print-tag/', BookingTagPrintView.as_view(), name='booking-tag-print'),
    path('booking-management/<int:pk>/edit/', BookingEditView.as_view(), name='booking-edit'),
    path('booking-management/<int:pk>/delete/', BookingDeleteView.as_view(), name='booking-delete'),
    path('booking-item/<int:pk>/update/', BookingItemUpdateView.as_view(), name='booking-item-update'),
    path('booking-item/<int:pk>/delete/', BookingItemDeleteView.as_view(), name='booking-item-delete'),
]
