from django.urls import path
from .views_api import (
    RiderRegistrationView,
    RiderLoginView,
    RiderProfileView,
    RiderUpdateView,
    RiderPasswordChangeView,
    rider_logout,
    rider_status_check
)

urlpatterns = [
    # Authentication endpoints
    path('register/', RiderRegistrationView.as_view(), name='rider-register'),
    path('login/', RiderLoginView.as_view(), name='rider-login'),
    path('logout/', rider_logout, name='rider-logout'),
    
    # Profile management endpoints
    path('profile/', RiderProfileView.as_view(), name='rider-profile'),
    path('profile/update/', RiderUpdateView.as_view(), name='rider-profile-update'),
    path('profile/change-password/', RiderPasswordChangeView.as_view(), name='rider-change-password'),
    
    # Utility endpoints
    path('status/', rider_status_check, name='rider-status-check'),
]