from django.urls import path
from users.views import (
    UserManagementView,
    UserCreateView,
    UserDetailViewWeb,
    UserEditView,
    UserDeleteView,
)

urlpatterns = [
    path('user-management/', UserManagementView.as_view(), name='user-management'),
    path('user-management/create', UserCreateView.as_view(), name='user-create'),
    path('user-management/<int:pk>/', UserDetailViewWeb.as_view(), name='user-view'),
    path('user-management/<int:pk>/edit/', UserEditView.as_view(), name='user-edit'),
    path('user-management/<int:pk>/delete/', UserDeleteView.as_view(), name='user-delete'),
]
